<?php
/**
 * @package RSForm! Pro
 * @copyright (C) 2007-2019 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/copyleft/gpl.html
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

$listOrder	= $this->escape($this->filter_order);
$listDirn	= $this->escape($this->filter_order_Dir);

Text::script('RSFP_SUBM_DIR_DELETE_SURE');
HTMLHelper::_('stylesheet', 'com_rsform/rsicons.css', array('relative' => true, 'version' => 'auto'));

$alignmentClass = $this->escape('directoryAlign' . ucfirst($this->params->get('alignment', 'center')));
?>

<!-- Add Custom CSS for Grid Layout -->
<style>
    .directory-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 20px;
        padding: 20px;
    }
    .directory-item {
        border: 1px solid #ddd;
        padding: 15px;
        border-radius: 8px;
        background-color: #f9f9f9;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }
    .directory-item img {
        max-width: 100%;
        height: auto;
        border-radius: 8px;
    }
    .directory-item .field {
        display: flex;
        align-items: center;
        margin-bottom: 10px;
    }
    .directory-item .field strong {
        margin-right: 10px;
        font-weight: bold;
        color: #333;
    }
    .directory-item .field span {
        color: #666;
    }
</style>

<div class="directory-grid">
    <?php if ($this->items) { ?>
        <?php foreach ($this->items as $i => $item) { ?>
            <div class="directory-item">
                <?php foreach ($this->viewableFields as $field) { ?>
                    <?php if ($field->FieldName === 'Maid_Photo') { ?>
                        <!-- Display Maid Photo as Image -->
                        <div class="field">
                            <img src="<?php echo $this->getValue($item, $field, 'path'); ?>" alt="Maid Photo">
                        </div>
                    <?php } else { ?>
                        <!-- Display Other Fields -->
                        <div class="field">
                            <strong><?php echo $field->FieldCaption; ?>:</strong>
                            <span><?php echo $this->getValue($item, $field); ?></span>
                        </div>
                    <?php } ?>
                <?php } ?>

                <!-- Actions (View, Edit, Delete, PDF) -->
                <div class="directory-actions">
                    <?php if ($this->hasDetailFields) { ?>
                        <a class="<?php echo $this->tooltipClass; ?> directoryDetail" title="<?php echo RSFormProHelper::getTooltipText(Text::_('RSFP_SUBM_DIR_VIEW')); ?>" href="<?php echo Route::_('index.php?option=com_rsform&view=directory&layout=view&id='.$item->SubmissionId); ?>">
                            <span class="rsficon rsficon-zoom-in"></span>
                        </a>
                    <?php } ?>
                    <?php if (RSFormProHelper::canEdit($this->params->get('formId'), $item->SubmissionId)) { ?>
                        <a class="<?php echo $this->tooltipClass; ?> directoryEdit" title="<?php echo RSFormProHelper::getTooltipText(Text::_('RSFP_SUBM_DIR_EDIT')); ?>" href="<?php echo Route::_('index.php?option=com_rsform&view=directory&layout=edit&id='.$item->SubmissionId); ?>">
                            <span class="rsficon rsficon-edit"></span>
                        </a>
                    <?php } ?>
                    <?php if (RSFormProHelper::canDelete($this->params->get('formId'), $item->SubmissionId)) { ?>
                        <a onclick="return confirm(Joomla.JText._('RSFP_SUBM_DIR_DELETE_SURE'));" class="<?php echo $this->tooltipClass; ?> directoryDelete" title="<?php echo RSFormProHelper::getTooltipText(Text::_('RSFP_SUBM_DIR_DELETE')); ?>" href="<?php echo Route::_('index.php?option=com_rsform&controller=directory&task=delete&id='.$item->SubmissionId); ?>">
                            <span class="rsficon rsficon-remove"></span>
                        </a>
                    <?php } ?>
                    <?php if ($this->directory->enablepdf) { ?>
                        <a class="<?php echo $this->tooltipClass; ?> directoryPdf" title="<?php echo RSFormProHelper::getTooltipText(Text::_('RSFP_SUBM_DIR_PDF')); ?>" href="<?php echo $this->pdfLink($item->SubmissionId); ?>">
                            <span class="rsficon rsficon-file-pdf"></span>
                        </a>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>
    <?php } else { ?>
        <p>No submissions found.</p>
    <?php } ?>
</div>