<?php
/**
 * @version 3.0.0
 * @package RSForm! Pro
 * @copyright (C) 2007-2021 www.rsjoomla.com
 * @license GPL, https://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Pagination\Pagination;
use Joomla\CMS\Language\Text;
use Joomla\Registry\Registry;

class ModRSFormListHelper
{
	protected $formId = 1;
	protected $params;
	protected $textareaFields = array();
	protected $multipleFields = array();
	protected $uploadFields = array();

	protected $_form;
	protected $_data = array();
	protected $_total = 0;
	protected $_query = '';
	protected $_pagination;
	protected $_db;
	protected $_state;
	
	public function __construct($params)
	{
		$this->params = $params;
		$this->formId = (int) $this->params->def('formId', 1);
		$this->_state = new Registry();
		
		$this->_db 		= Factory::getDbo();
		$this->_query 	= $this->_buildQuery();
		
		// Get pagination request variables
		$limit 		= $this->params->def('limit', 30);
		$limitstart	= Factory::getApplication()->input->getInt('mod_rsform_listlimitstart', 0);
		
		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
		
		$this->setState('mod_rsform_list.submissions.'.$this->formId.'.limit', $limit);
		$this->setState('mod_rsform_list.submissions.'.$this->formId.'.limitstart', $limitstart);
	}
	
	public function getUrl($submissionId) {
		static $type = array(); 
		static $itemId;
		
		if (!isset($type[$this->formId])) {
			$type[$this->formId]	= 'module';
			$itemId					= (int) $this->params->get('menu_type_itemid');
			
			// Do we have menu item ID set?
			if ($itemId) {
				// Let's check the menu item type
				if (($item = Factory::getApplication()->getMenu()->getItem($itemId)) // Menu item exists
					&& (isset($item->query) && is_array($item->query)) // Has query element and it's an array
					&& (isset($item->query['option']) && ($item->query['option'] == 'com_rsform')) // Is an RSForm! Pro menu item
					&& (isset($item->query['view']) && ($item->query['view'] == 'submissions' || $item->query['view'] == 'directory')) // Points to Submissions or Directory.
					) {
						// Everything looks good here, grab the menu type
						$type[$this->formId] = $item->query['view'];
				}
			}
		}
		
		switch ($type[$this->formId])
		{
			case 'submissions':
				return Route::_("index.php?option=com_rsform&view=submissions&layout=view&cid=$submissionId&Itemid=$itemId");
			break;
			
			case 'directory':
				return Route::_("index.php?option=com_rsform&view=directory&layout=view&id=$submissionId&Itemid=$itemId");
			break;
			
			case 'module':
			default:
				// Build base URL.
				static $baseUrl;
				if (!$baseUrl) {
					$uri = Uri::getInstance();
					$uri->delVar('detail'.$this->formId);
					$baseUrl  = (string) $uri;
					$baseUrl .= strpos($baseUrl, '?') !== false ? '&' : '?';
				}
				
				return Route::_("{$baseUrl}detail{$this->formId}=$submissionId");
			break;
		}
	}
	
	public function getDate($date)
	{
		return RSFormProHelper::getDate($date);
	}
	
	public function getForm()
	{
		$query = $this->_db->getQuery(true)
			->select($this->_db->qn('MultipleSeparator'))
			->select($this->_db->qn('TextareaNewLines'))
			->from($this->_db->qn('#__rsform_forms'))
			->where($this->_db->qn('FormId') . ' = ' . $this->_db->q($this->formId));
		$form = $this->_db->setQuery($query)->loadObject();

		$form->MultipleSeparator = str_replace(array('\n', '\r', '\t'), array("\n", "\r", "\t"), $form->MultipleSeparator);

		return $form;
	}
	
	protected function _buildQuery()
	{
		$query = $this->_db->getQuery(true)
			->select('*')
			->from($this->_db->qn('#__rsform_submissions', 's'))
			->where($this->_db->qn('s.FormId') . ' = ' . $this->_db->q($this->formId));

		if ($this->params->get('show_confirmed', 0))
		{
			$query->where($this->_db->qn('s.confirmed') . ' = ' . $this->_db->q(1));
		}

		if ($lang = $this->params->get('lang', ''))
		{
			$query->where($this->_db->qn('s.Lang') . ' = ' . $this->_db->q($lang));
		}

		$userId = $this->params->def('userId', 0);
		$user = Factory::getUser();

		if ($userId === 'login')
		{
			$userId = $user->id ? $user->id : '-1';
		}

		$userId = explode(',', $userId);
		$userId = array_map('intval', $userId);

		// userId = 0 means show all submissions, otherwise just show what we specified
		if (!in_array(0, $userId))
		{
			$query->where($this->_db->qn('s.UserId') . ' IN (' . implode(',', $this->_db->q($userId)) . ')');
		}
		// Set ordering
		$dir = $this->params->get('sort_submissions') ? 'ASC' : 'DESC';
		$query->order($this->_db->qn('s.DateSubmitted') . ' ' . $this->_db->escape($dir));

		return $query;
	}
	
	public function getPagination()
	{
		if (empty($this->_pagination))
		{
			$this->_pagination = new Pagination($this->getTotal(), $this->getState('mod_rsform_list.submissions.'.$this->formId.'.limitstart'), $this->getState('mod_rsform_list.submissions.'.$this->formId.'.limit'), 'mod_rsform_list');
		}
		
		return $this->_pagination;
	}
	
	public function getTotal()
	{
		return $this->_total;
	}

	protected function _getListCount($query)
	{
		$query = clone $query;
		$query->clear('select')->clear('order')->clear('limit')->clear('offset')->select('COUNT(*)');

		$this->_db->setQuery($query);

		return (int) $this->_db->loadResult();
	}
	
	public function getSubmissions()
	{
		if (empty($this->_data))
		{
			$this->getComponents();

			$this->_db->setQuery("SET SQL_BIG_SELECTS=1");
			$this->_db->execute();
			
			$submissionIds = array();
			
			$this->_db->setQuery($this->_query, $this->getState('mod_rsform_list.submissions.'.$this->formId.'.limitstart'), $this->getState('mod_rsform_list.submissions.'.$this->formId.'.limit'));
			$results = $this->_db->loadObjectList();

			$this->_total = $this->_getListCount($this->_query);

			foreach ($results as $result)
			{
				$submissionIds[] = $result->SubmissionId;

				$this->_data[$result->SubmissionId]['FormId'] = $result->FormId;
				$this->_data[$result->SubmissionId]['DateSubmitted'] = $this->getDate($result->DateSubmitted);
				$this->_data[$result->SubmissionId]['UserIp'] = $result->UserIp;
				$this->_data[$result->SubmissionId]['Username'] = $result->Username;
				$this->_data[$result->SubmissionId]['UserId'] = $result->UserId;
				$this->_data[$result->SubmissionId]['confirmed'] = $result->confirmed ? Text::_('RSFP_YES') : Text::_('RSFP_NO');
				$this->_data[$result->SubmissionId]['ConfirmedIp'] = $result->ConfirmedIp;
				$this->_data[$result->SubmissionId]['ConfirmedDate'] = $this->getDate($result->ConfirmedDate);
				$this->_data[$result->SubmissionId]['SubmissionHash'] = $result->SubmissionHash;
				$this->_data[$result->SubmissionId]['ConfirmationHash'] = md5($result->SubmissionId . $result->FormId . $result->DateSubmitted);
				$this->_data[$result->SubmissionId]['SubmissionValues'] = array();
			}
			
			$form = $this->getForm();
			
			if (!empty($submissionIds))
			{
				$query = $this->_db->getQuery(true)
					->select('*')
					->from($this->_db->qn('#__rsform_submission_values'))
					->where($this->_db->qn('SubmissionId') . ' IN (' . implode(',', $this->_db->q($submissionIds)) . ')');
				$this->_db->setQuery($query);
				$results = $this->_db->loadObjectList();
				
				$config = Factory::getConfig();
				$secret = $config->get('secret');
				foreach ($results as $result)
				{
					// Check if this is an upload field
					if (in_array($result->FieldName, $this->uploadFields) && !empty($result->FieldValue))
					{
						$result->FilePath = $result->FieldValue;

						$files = RSFormProHelper::explode($result->FieldValue);
						$actualValues = array();
						foreach ($files as $file)
						{
							$actualValues[] = '<a href="' . Route::_('index.php?option=com_rsform&task=submissions.viewfile&hash=' . md5($result->SubmissionId . $secret . $result->FieldName) . '&file=' . md5($file)) . '">' . RSFormProHelper::htmlEscape(basename($file)) . '</a>';
						}
						$result->FieldValue = implode('<br />', $actualValues);
					}
					// Check if this is a multiple field
					elseif (in_array($result->FieldName, $this->multipleFields))
					{
						$result->FieldValue = str_replace("\n", $form->MultipleSeparator, $result->FieldValue);
					}
					elseif ($form->TextareaNewLines && in_array($result->FieldName, $this->textareaFields))
					{
						$result->FieldValue = nl2br($result->FieldValue);
					}
						
					$this->_data[$result->SubmissionId]['SubmissionValues'][$result->FieldName] = array('Value' => $result->FieldValue, 'Id' => $result->SubmissionValueId);

					if (!empty($result->FilePath))
					{
						$files = RSFormProHelper::explode($result->FilePath);

						$actualValues = array();
						$images = array();
						$filenames = array();
						foreach ($files as $filepath)
						{
							$filepath = str_replace(JPATH_SITE.DIRECTORY_SEPARATOR, Uri::root(), $filepath);
							$filepath = str_replace(array('\\', '\\/', '//\\'), '/', $filepath);

							$actualValues[] = $filepath;
							$images[] = '<img src="' . RSFormProHelper::htmlEscape($filepath) . '">';
							$filenames[] = basename($filepath);
						}

						$this->_data[$result->SubmissionId]['SubmissionValues'][$result->FieldName]['Path'] = implode('<br />', $actualValues);
						$this->_data[$result->SubmissionId]['SubmissionValues'][$result->FieldName]['Image'] = implode('<br />', $images);
						$this->_data[$result->SubmissionId]['SubmissionValues'][$result->FieldName]['Filename'] = implode('<br />', $filenames);
					}
				}
			}
			unset($results);
		}
		
		return $this->_data;
	}
	
	public function getReplacements($user_id=0, $globals = false)
	{
		static $sitename, $siteurl, $mailfrom, $fromname;

		if (is_null($siteurl))
		{
			$config 	= Factory::getConfig();
			$sitename 	= $config->get('sitename');
			$siteurl	= Uri::root();
			$mailfrom	= $config->get('mailfrom');
			$fromname	= $config->get('fromname');
		}

		$user = Factory::getUser((int) $user_id);

		if ($globals)
		{
			$replace = array('{global:sitename}', '{global:siteurl}', '{global:userid}', '{global:username}', '{global:email}', '{global:fullname}', '{global:mailfrom}', '{global:fromname}', '{/details}', '{/detailspdf}');
			$with 	 = array($sitename, Uri::root(), $user->get('id'), $user->get('username'), $user->get('email'), $user->get('name'), $mailfrom, $fromname, '</a>', '</a>');
		}
		else
		{
			$replace = array('{global:email}', '{/details}', '{/detailspdf}');
			$with 	 = array($user->get('email'), '</a>', '</a>');
		}
			
		return array($replace, $with);
	}
	
	protected function getComponents()
	{
		list($multipleSeparator, $this->uploadFields, $this->multipleFields, $this->textareaFields, $secret) = RSFormProHelper::getDirectoryFormProperties($this->formId);
	}
	
	public function getHeaders()
	{
		$headers = array();

		if ($fields = RSFormProHelper::getComponents($this->formId))
		{
			foreach ($fields as $field)
			{
				$headers[] = $field->name;
			}
		}
		
		return $headers;
	}
	
	protected function getState($property) {
		return $this->_state->get($property);
	}
	
	protected function setState($property, $value) {
		return $this->_state->set($property, $value);
	}
}