<?php
defined('_JEXEC') or die;

class ModNgoStatusHelper
{
    public static function getNgoStatus()
    {
        $user = JFactory::getUser(); // Get the current logged-in user
        if ($user->guest) {
            return null; // If the user is not logged in, return null
        }

        $db = JFactory::getDbo();

        // Get the most recent submission ID for the current user and form ID 3
        $query = $db->getQuery(true)
            ->select($db->quoteName('SubmissionId'))
            ->from($db->quoteName('#__rsform_submissions'))
            ->where($db->quoteName('FormId') . ' = 3')
            ->where($db->quoteName('UserId') . ' = ' . $db->quote($user->id))
            ->order($db->quoteName('SubmissionId') . ' DESC')
            ->setLimit(1);

        $db->setQuery($query);
        $submissionId = $db->loadResult();

        if (!$submissionId) {
            return null; // No submission found for the current user
        }

        // Get the value of the `ngo_status` field for the submission
        $query = $db->getQuery(true)
            ->select($db->quoteName('FieldValue'))
            ->from($db->quoteName('#__rsform_submission_values'))
            ->where($db->quoteName('SubmissionId') . ' = ' . $db->quote($submissionId))
            ->where($db->quoteName('FieldName') . ' = ' . $db->quote('ngo_status'));

        $db->setQuery($query);
        return $db->loadResult();
    }
}