<?php
defined('_JEXEC') or die;

// Load Bootstrap and FontAwesome
JHtml::_('bootstrap.framework');
JHtml::_('stylesheet', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css');
JHtml::_('stylesheet', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css');
?>

<div class="maids-dashboard container">
    <h2 class="text-center mb-4">Maids Management System Dashboard</h2>

    <!-- New Maid Count Metrics -->
    <div class="row">
        <div class="col-md-4 mb-4">
            <div class="card text-white bg-primary">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-calendar-plus"></i> Total Maids Added - Current Month</h5>
                    <p class="card-text display-6"><?php echo $metrics['total_maids_current_month'] ?? 0; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-calendar-minus"></i> Total Maids Added - Last Month</h5>
                    <p class="card-text display-6"><?php echo $metrics['total_maids_last_month'] ?? 0; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card text-white bg-info">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-calendar-check"></i> Total Maids Added - Month Before Last</h5>
                    <p class="card-text display-6"><?php echo $metrics['total_maids_month_before_last'] ?? 0; ?></p>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4 mb-4">
            <div class="card text-white bg-warning">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-briefcase"></i> Total Maids Deployed</h5>
                    <p class="card-text display-6"><?php echo $metrics['total_maids_deployed'] ?? 0; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card text-white bg-success">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-user-check"></i> Total Maids Available</h5>
                    <p class="card-text display-6"><?php echo $metrics['total_maids_available'] ?? 0; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card text-white bg-danger">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-user-times"></i> Total Maids Unavailable</h5>
                    <p class="card-text display-6"><?php echo $metrics['total_maids_unavailable'] ?? 0; ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Team Member Metrics -->
    <div class="row">
        <div class="col-md-6 mb-4">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="card-title"><i class="fas fa-users"></i> Maids Added by Team Members - Current Month</h5>
                </div>
                <div class="card-body">
                    <?php if (!empty($metrics['maids_by_team_current_month'])): ?>
                        <ul class="list-group">
                            <?php foreach ($metrics['maids_by_team_current_month'] as $member => $count): ?>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <?php echo htmlspecialchars($member); ?>
                                    <span class="badge bg-primary rounded-pill"><?php echo $count; ?></span>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php else: ?>
                        <p class="text-muted">No team member data for current month</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="col-md-6 mb-4">
            <div class="card">
                <div class="card-header bg-success text-white">
                    <h5 class="card-title"><i class="fas fa-users"></i> Maids Added by Team Members - Last Month</h5>
                </div>
                <div class="card-body">
                    <?php if (!empty($metrics['maids_by_team_last_month'])): ?>
                        <ul class="list-group">
                            <?php foreach ($metrics['maids_by_team_last_month'] as $member => $count): ?>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <?php echo htmlspecialchars($member); ?>
                                    <span class="badge bg-success rounded-pill"><?php echo $count; ?></span>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php else: ?>
                        <p class="text-muted">No team member data for last month</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Photo and Document Metrics -->
    <div class="row">
        <div class="col-md-6 mb-4">
            <div class="card">
                <div class="card-header bg-warning">
                    <h5 class="card-title"><i class="fas fa-camera"></i> Photo Status</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            Maids with Missing Photos
                            <span class="badge bg-warning rounded-pill"><?php echo $metrics['maids_photos_missing'] ?? 0; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            Placed Maids with Missing Photos
                            <span class="badge bg-danger rounded-pill"><?php echo $metrics['placed_maids_photos_missing'] ?? 0; ?></span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-md-6 mb-4">
            <div class="card">
                <div class="card-header bg-info text-white">
                    <h5 class="card-title"><i class="fas fa-file-alt"></i> Placed Maids Document Status</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            Documents Missing
                            <span class="badge bg-danger rounded-pill"><?php echo $metrics['placed_maids_documents_missing'] ?? 0; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            Total Documents: 1
                            <span class="badge bg-warning rounded-pill"><?php echo $metrics['placed_maids_documents_1'] ?? 0; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            Total Documents: 2
                            <span class="badge bg-info rounded-pill"><?php echo $metrics['placed_maids_documents_2'] ?? 0; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            Total Documents: 3
                            <span class="badge bg-success rounded-pill"><?php echo $metrics['placed_maids_documents_3'] ?? 0; ?></span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Existing Metrics to Keep -->
    <div class="row">
        <div class="col-md-12 mb-4">
            <div class="card">
                <div class="card-header bg-success text-white">
                    <h5 class="card-title"><i class="fas fa-building"></i> Active With Lafab Solutions</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <?php foreach ($metrics['active_counts'] as $active => $count) : ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo $active; ?>
                                <span class="badge bg-success rounded-pill"><?php echo $count ?? 0; ?></span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 mb-4">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="card-title"><i class="fas fa-box"></i> Current Package Metrics</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <?php foreach ($metrics['package_counts'] as $package => $count) : ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo $package; ?>
                                <span class="badge bg-primary rounded-pill"><?php echo $count ?? 0; ?></span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 mb-4">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    <h5 class="card-title"><i class="fas fa-star"></i> Maid Rating Metrics</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <?php foreach ($metrics['rating_counts'] as $rating => $count) : ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo $rating; ?>
                                <span class="badge bg-warning rounded-pill"><?php echo $count ?? 0; ?></span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>