<?php
// Load Joomla Framework
define('_JEXEC', 1);
define('JPATH_BASE', dirname(__FILE__, 2)); // Adjust the path based on location
require_once JPATH_BASE . '/includes/defines.php';
require_once JPATH_BASE . '/includes/framework.php';

// Initialize Joomla Application
$app = JFactory::getApplication('site');

// Database Connection
$db = JFactory::getDBO();

// Get Today's Date
$today = date('Y-m-d');

// Query to Find NGOs That Need Renewal in 30 Days
$query = $db->getQuery(true)
    ->select($db->quoteName(['id', 'email', 'ngo_name', 'renewal_date']))
    ->from($db->quoteName('#__rsform_submissions'))
    ->where('DATE_SUB(renewal_date, INTERVAL 30 DAY) = CURDATE()'); 

$db->setQuery($query);
$ngos = $db->loadObjectList();

// Send Emails
foreach ($ngos as $ngo) {
    $subject = "Renewal Reminder: " . $ngo->ngo_name;
    $body = "Dear " . $ngo->ngo_name . ",\n\n";
    $body .= "Your NGO registration renewal is due in 30 days. Please log in and complete the renewal process.\n\n";
    $body .= "Best Regards,\nDepartment of NGO Management";

    // Send Email
    $mailer = JFactory::getMailer();
    $mailer->setSender(array('admin@example.com', 'NGO Management System'));
    $mailer->addRecipient($ngo->email);
    $mailer->setSubject($subject);
    $mailer->setBody($body);
    $mailer->send();
}

// Print Result for Debugging
echo "Renewal reminders sent successfully!";
?>
