<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;

class ModRsformSubmissionsHelper
{
    public static function getSubmissionData($formId)
    {
        $db = Factory::getDbo();

        // Predefined list of statuses
        $statuses = [
            'Front Desk Review',
            'Accounts Verification',
            'Compliance Review',
            'Legal Review',
            'Records Update',
            'Approved',
            'Rejected',
            'Pending'
        ];

        // Initialize status counts to zero
        $statusCounts = array_fill_keys($statuses, 0);

        // Fetch total submissions and status counts
        $query = $db->getQuery(true)
            ->select([
                'COUNT(s.SubmissionId) as totalSubmissions',
                'sv.FieldValue as status',
                'COUNT(sv.SubmissionId) as statusCount'
            ])
            ->from($db->quoteName('#__rsform_submissions', 's'))
            ->join('LEFT', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON s.SubmissionId = sv.SubmissionId')
            ->where($db->quoteName('s.FormId') . ' = ' . (int)$formId)
            ->where($db->quoteName('sv.FieldName') . ' = ' . $db->quote('ngo_status'))
            ->group($db->quoteName('sv.FieldValue'));

        $db->setQuery($query);
        $results = $db->loadObjectList();

        $totalSubmissions = 0;

        // Update status counts with actual data
        foreach ($results as $row) {
            if (isset($statusCounts[$row->status])) {
                $statusCounts[$row->status] = (int)$row->statusCount;
                $totalSubmissions += (int)$row->statusCount;
            }
        }

        return [
            'totalSubmissions' => $totalSubmissions,
            'statusCounts' => $statusCounts
        ];
    }
}