<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;

// Get the form ID from the module parameters
$formId = $params->get('form_id');

if (!$formId) {
    echo 'Please configure the Form ID in the module settings.';
    return;
}

// Get the database object
$db = Factory::getDbo();

// Get the selected time period from the request
$selectedPeriod = Factory::getApplication()->input->getString('period', 'today');

// Define the date range based on the selected period
$currentDate = date('Y-m-d');
switch ($selectedPeriod) {
    case 'today':
        $startDate = $currentDate;
        $endDate = $currentDate;
        break;
    case '1_day_ago':
        $startDate = date('Y-m-d', strtotime('-1 day'));
        $endDate = $startDate;
        break;
    case '2_days_ago':
        $startDate = date('Y-m-d', strtotime('-2 days'));
        $endDate = $startDate;
        break;
    case '3_days_ago':
        $startDate = date('Y-m-d', strtotime('-3 days'));
        $endDate = $startDate;
        break;
    case '4_days_ago':
        $startDate = date('Y-m-d', strtotime('-4 days'));
        $endDate = $startDate;
        break;
    case '5_days_ago':
        $startDate = date('Y-m-d', strtotime('-5 days'));
        $endDate = $startDate;
        break;
    case '6_days_ago':
        $startDate = date('Y-m-d', strtotime('-6 days'));
        $endDate = $startDate;
        break;
    case '7_days_ago':
        $startDate = date('Y-m-d', strtotime('-7 days'));
        $endDate = $startDate;
        break;
    case 'last_7_days':
        $startDate = date('Y-m-d', strtotime('-6 days'));
        $endDate = $currentDate;
        break;
    case 'last_30_days':
        $startDate = date('Y-m-d', strtotime('-29 days'));
        $endDate = $currentDate;
        break;
    case '1_year':
        $startDate = date('Y-m-d', strtotime('-1 year'));
        $endDate = $currentDate;
        break;
    default:
        $startDate = $currentDate;
        $endDate = $currentDate;
        break;
}

// Function to calculate metrics for a given date range
function calculateMetrics($db, $formId, $startDate, $endDate) {
    $metrics = [];

    // Query to get the total number of workers for the date range
    $query = $db->getQuery(true)
        ->select('COUNT(DISTINCT s.SubmissionId)')
        ->from($db->quoteName('#__rsform_submissions', 's'))
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON s.SubmissionId = sv.SubmissionId')
        ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
        ->where($db->quoteName('sv.FieldName') . ' = ' . $db->quote('Local_Time'))
        ->where('DATE(sv.FieldValue) BETWEEN ' . $db->quote($startDate) . ' AND ' . $db->quote($endDate));
    $db->setQuery($query);
    $metrics['totalWorkers'] = (int)$db->loadResult();

    // Query to get the total number of early arrivals (before 8:30 AM)
    $query = $db->getQuery(true)
        ->select('COUNT(DISTINCT s.SubmissionId)')
        ->from($db->quoteName('#__rsform_submissions', 's'))
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON s.SubmissionId = sv.SubmissionId')
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv2') . ' ON s.SubmissionId = sv2.SubmissionId')
        ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
        ->where($db->quoteName('sv.FieldName') . ' = ' . $db->quote('Local_Time'))
        ->where('DATE(sv.FieldValue) BETWEEN ' . $db->quote($startDate) . ' AND ' . $db->quote($endDate))
        ->where($db->quoteName('sv2.FieldName') . ' = ' . $db->quote('Check-in'))
        ->where('STR_TO_DATE(TRIM(sv2.FieldValue), \'%h:%i %p\') < STR_TO_DATE(\'08:30:00\', \'%H:%i:%s\')');
    $db->setQuery($query);
    $metrics['totalEarlyArrivals'] = (int)$db->loadResult();

    // Query to get the total number of late arrivals (after 8:30 AM)
    $query = $db->getQuery(true)
        ->select('COUNT(DISTINCT s.SubmissionId)')
        ->from($db->quoteName('#__rsform_submissions', 's'))
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON s.SubmissionId = sv.SubmissionId')
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv2') . ' ON s.SubmissionId = sv2.SubmissionId')
        ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
        ->where($db->quoteName('sv.FieldName') . ' = ' . $db->quote('Local_Time'))
        ->where('DATE(sv.FieldValue) BETWEEN ' . $db->quote($startDate) . ' AND ' . $db->quote($endDate))
        ->where($db->quoteName('sv2.FieldName') . ' = ' . $db->quote('Check-in'))
        ->where('STR_TO_DATE(TRIM(sv2.FieldValue), \'%h:%i %p\') > STR_TO_DATE(\'08:30:00\', \'%H:%i:%s\')');
    $db->setQuery($query);
    $metrics['totalLateArrivals'] = (int)$db->loadResult();

    // Query to get the total number of workers who checked out after 5:00 PM
    $query = $db->getQuery(true)
        ->select('COUNT(DISTINCT s.SubmissionId)')
        ->from($db->quoteName('#__rsform_submissions', 's'))
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON s.SubmissionId = sv.SubmissionId')
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv2') . ' ON s.SubmissionId = sv2.SubmissionId')
        ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
        ->where($db->quoteName('sv.FieldName') . ' = ' . $db->quote('Local_Time'))
        ->where('DATE(sv.FieldValue) BETWEEN ' . $db->quote($startDate) . ' AND ' . $db->quote($endDate))
        ->where($db->quoteName('sv2.FieldName') . ' = ' . $db->quote('CheckOutTime'))
        ->where('STR_TO_DATE(TRIM(sv2.FieldValue), \'%h:%i %p\') > STR_TO_DATE(\'17:00:00\', \'%H:%i:%s\')');
    $db->setQuery($query);
    $metrics['totalLateCheckouts'] = (int)$db->loadResult();

    // Query to get the total hours worked
    $query = $db->getQuery(true)
        ->select('SUM(CAST(sv2.FieldValue AS DECIMAL(10,2)))')
        ->from($db->quoteName('#__rsform_submissions', 's'))
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON s.SubmissionId = sv.SubmissionId')
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv2') . ' ON s.SubmissionId = sv2.SubmissionId')
        ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
        ->where($db->quoteName('sv.FieldName') . ' = ' . $db->quote('Local_Time'))
        ->where('DATE(sv.FieldValue) BETWEEN ' . $db->quote($startDate) . ' AND ' . $db->quote($endDate))
        ->where($db->quoteName('sv2.FieldName') . ' = ' . $db->quote('HoursWorked'));
    $db->setQuery($query);
    $metrics['totalHoursWorked'] = (int)$db->loadResult();

    // Query to get the total overtime worked
    $query = $db->getQuery(true)
        ->select('SUM(CAST(sv2.FieldValue AS DECIMAL(10,2)))')
        ->from($db->quoteName('#__rsform_submissions', 's'))
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON s.SubmissionId = sv.SubmissionId')
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv2') . ' ON s.SubmissionId = sv2.SubmissionId')
        ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
        ->where($db->quoteName('sv.FieldName') . ' = ' . $db->quote('Local_Time'))
        ->where('DATE(sv.FieldValue) BETWEEN ' . $db->quote($startDate) . ' AND ' . $db->quote($endDate))
        ->where($db->quoteName('sv2.FieldName') . ' = ' . $db->quote('Overtime'));
    $db->setQuery($query);
    $metrics['totalOvertimeWorked'] = (int)$db->loadResult();

    // Query to get the total number of workers with PPE
    $query = $db->getQuery(true)
        ->select('COUNT(DISTINCT s.SubmissionId)')
        ->from($db->quoteName('#__rsform_submissions', 's'))
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON s.SubmissionId = sv.SubmissionId')
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv2') . ' ON s.SubmissionId = sv2.SubmissionId')
        ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
        ->where($db->quoteName('sv.FieldName') . ' = ' . $db->quote('Local_Time'))
        ->where('DATE(sv.FieldValue) BETWEEN ' . $db->quote($startDate) . ' AND ' . $db->quote($endDate))
        ->where($db->quoteName('sv2.FieldName') . ' = ' . $db->quote('HasPPE'))
        ->where($db->quoteName('sv2.FieldValue') . ' = ' . $db->quote('Yes'));
    $db->setQuery($query);
    $metrics['totalWithPPE'] = (int)$db->loadResult();

    // Query to get the total number of workers without PPE
    $query = $db->getQuery(true)
        ->select('COUNT(DISTINCT s.SubmissionId)')
        ->from($db->quoteName('#__rsform_submissions', 's'))
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON s.SubmissionId = sv.SubmissionId')
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv2') . ' ON s.SubmissionId = sv2.SubmissionId')
        ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
        ->where($db->quoteName('sv.FieldName') . ' = ' . $db->quote('Local_Time'))
        ->where('DATE(sv.FieldValue) BETWEEN ' . $db->quote($startDate) . ' AND ' . $db->quote($endDate))
        ->where($db->quoteName('sv2.FieldName') . ' = ' . $db->quote('HasPPE'))
        ->where($db->quoteName('sv2.FieldValue') . ' = ' . $db->quote('No'));
    $db->setQuery($query);
    $metrics['totalWithoutPPE'] = (int)$db->loadResult();

    // Query to get the total daily payments
    $query = $db->getQuery(true)
        ->select('SUM(CAST(sv2.FieldValue AS DECIMAL(10,2)))')
        ->from($db->quoteName('#__rsform_submissions', 's'))
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON s.SubmissionId = sv.SubmissionId')
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv2') . ' ON s.SubmissionId = sv2.SubmissionId')
        ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
        ->where($db->quoteName('sv.FieldName') . ' = ' . $db->quote('Local_Time'))
        ->where('DATE(sv.FieldValue) BETWEEN ' . $db->quote($startDate) . ' AND ' . $db->quote($endDate))
        ->where($db->quoteName('sv2.FieldName') . ' = ' . $db->quote('PayAmount'));
    $db->setQuery($query);
    $metrics['totalDailyPayments'] = (int)$db->loadResult();

    // Query to get the total daily overtime payments
    $query = $db->getQuery(true)
        ->select('SUM(CAST(sv2.FieldValue AS DECIMAL(10,2)))')
        ->from($db->quoteName('#__rsform_submissions', 's'))
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON s.SubmissionId = sv.SubmissionId')
        ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv2') . ' ON s.SubmissionId = sv2.SubmissionId')
        ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
        ->where($db->quoteName('sv.FieldName') . ' = ' . $db->quote('Local_Time'))
        ->where('DATE(sv.FieldValue) BETWEEN ' . $db->quote($startDate) . ' AND ' . $db->quote($endDate))
        ->where($db->quoteName('sv2.FieldName') . ' = ' . $db->quote('OvertimePayAmount'));
    $db->setQuery($query);
    $metrics['totalDailyOvertimePayments'] = (int)$db->loadResult();

    // Query to get the total number of workers for each Worker Efficiency Rating
    $efficiencyRatings = ['Unsatisfactory', 'Needs Improvement', 'Meets Expectations', 'Exceeds Expectations', 'Outstanding'];
    $metrics['efficiencyCounts'] = [];
    foreach ($efficiencyRatings as $rating) {
        $query = $db->getQuery(true)
            ->select('COUNT(DISTINCT s.SubmissionId)')
            ->from($db->quoteName('#__rsform_submissions', 's'))
            ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON s.SubmissionId = sv.SubmissionId')
            ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv2') . ' ON s.SubmissionId = sv2.SubmissionId')
            ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
            ->where($db->quoteName('sv.FieldName') . ' = ' . $db->quote('Local_Time'))
            ->where('DATE(sv.FieldValue) BETWEEN ' . $db->quote($startDate) . ' AND ' . $db->quote($endDate))
            ->where($db->quoteName('sv2.FieldName') . ' = ' . $db->quote('WorkerEfficiencyRating'))
            ->where($db->quoteName('sv2.FieldValue') . ' = ' . $db->quote($rating));
        $db->setQuery($query);
        $metrics['efficiencyCounts'][$rating] = (int)$db->loadResult();
    }

    // Query to get the total number of workers for each Supervisor Performance Rating
    $performanceRatings = ['Poor', 'Fair', 'Good', 'Very Good', 'Excellent'];
    $metrics['performanceCounts'] = [];
    foreach ($performanceRatings as $rating) {
        $query = $db->getQuery(true)
            ->select('COUNT(DISTINCT s.SubmissionId)')
            ->from($db->quoteName('#__rsform_submissions', 's'))
            ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON s.SubmissionId = sv.SubmissionId')
            ->join('INNER', $db->quoteName('#__rsform_submission_values', 'sv2') . ' ON s.SubmissionId = sv2.SubmissionId')
            ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
            ->where($db->quoteName('sv.FieldName') . ' = ' . $db->quote('Local_Time'))
            ->where('DATE(sv.FieldValue) BETWEEN ' . $db->quote($startDate) . ' AND ' . $db->quote($endDate))
            ->where($db->quoteName('sv2.FieldName') . ' = ' . $db->quote('SupervisorPerformanceRemarks'))
            ->where($db->quoteName('sv2.FieldValue') . ' = ' . $db->quote($rating));
        $db->setQuery($query);
        $metrics['performanceCounts'][$rating] = (int)$db->loadResult();
    }

    return $metrics;
}

// Calculate metrics for the selected period
$metrics = calculateMetrics($db, $formId, $startDate, $endDate);

// Load the Bootstrap and FontAwesome CSS
JHtml::_('bootstrap.framework');
JHtml::_('bootstrap.loadCss', true);
JHtml::_('stylesheet', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css', array('version' => 'auto', 'relative' => true));

?>

<!-- Dropdown for selecting the time period -->
<form method="get" action="" class="mb-4">
    <select name="period" onchange="this.form.submit()" class="form-select">
        <option value="today" <?php echo $selectedPeriod === 'today' ? 'selected' : ''; ?>>Today</option>
        <option value="1_day_ago" <?php echo $selectedPeriod === '1_day_ago' ? 'selected' : ''; ?>>1 Day Ago</option>
        <option value="2_days_ago" <?php echo $selectedPeriod === '2_days_ago' ? 'selected' : ''; ?>>2 Days Ago</option>
        <option value="3_days_ago" <?php echo $selectedPeriod === '3_days_ago' ? 'selected' : ''; ?>>3 Days Ago</option>
        <option value="4_days_ago" <?php echo $selectedPeriod === '4_days_ago' ? 'selected' : ''; ?>>4 Days Ago</option>
        <option value="5_days_ago" <?php echo $selectedPeriod === '5_days_ago' ? 'selected' : ''; ?>>5 Days Ago</option>
        <option value="6_days_ago" <?php echo $selectedPeriod === '6_days_ago' ? 'selected' : ''; ?>>6 Days Ago</option>
        <option value="7_days_ago" <?php echo $selectedPeriod === '7_days_ago' ? 'selected' : ''; ?>>7 Days Ago</option>
        <option value="last_7_days" <?php echo $selectedPeriod === 'last_7_days' ? 'selected' : ''; ?>>Last 7 Days</option>
        <option value="last_30_days" <?php echo $selectedPeriod === 'last_30_days' ? 'selected' : ''; ?>>Last 30 Days</option>
        <option value="1_year" <?php echo $selectedPeriod === '1_year' ? 'selected' : ''; ?>>1 Year</option>
    </select>
</form>

<!-- Display the dashboard -->
<div class="casual-work-dashboard">
    <h3>Casual Work Dashboard</h3>
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-users"></i> Total Workers</h5>
                    <p class="card-text"><?php echo $metrics['totalWorkers']; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-clock"></i> Early Arrivals</h5>
                    <p class="card-text"><?php echo $metrics['totalEarlyArrivals']; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-clock"></i> Late Arrivals</h5>
                    <p class="card-text"><?php echo $metrics['totalLateArrivals']; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-clock"></i> Late Checkouts</h5>
                    <p class="card-text"><?php echo $metrics['totalLateCheckouts']; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-clock"></i> Total Hours Worked</h5>
                    <p class="card-text"><?php echo $metrics['totalHoursWorked']; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-clock"></i> Total Overtime Worked</h5>
                    <p class="card-text"><?php echo $metrics['totalOvertimeWorked']; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-hard-hat"></i> Workers with PPE</h5>
                    <p class="card-text"><?php echo $metrics['totalWithPPE']; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-hard-hat"></i> Workers without PPE</h5>
                    <p class="card-text"><?php echo $metrics['totalWithoutPPE']; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-money-bill-wave"></i> Total Daily Payments</h5>
                    <p class="card-text"><?php echo $metrics['totalDailyPayments']; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-money-bill-wave"></i> Total Daily Overtime Payments</h5>
                    <p class="card-text"><?php echo $metrics['totalDailyOvertimePayments']; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-chart-bar"></i> Worker Efficiency Ratings</h5>
                    <ul class="list-group">
                        <?php foreach ($metrics['efficiencyCounts'] as $rating => $count): ?>
                            <li class="list-group-item"><?php echo $rating; ?>: <?php echo $count; ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><i class="fas fa-chart-bar"></i> Supervisor Performance Ratings</h5>
                    <ul class="list-group">
                        <?php foreach ($metrics['performanceCounts'] as $rating => $count): ?>
                            <li class="list-group-item"><?php echo $rating; ?>: <?php echo $count; ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>