<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;

class Casual_Work_DashboardModelDashboard extends JModelLegacy
{
	public function getMetrics($formId, $timePeriod = 'today')
	{
    	$db = Factory::getDbo();
    	$now = Factory::getDate();
    	$today = $now->format('Y-m-d'); // Format: 2025-02-17

    	// Calculate the start and end dates based on the selected time period
    	switch ($timePeriod) {
        	case 'today':
            	$startDate = $today;
            	$endDate = $today;
            	break;
        	case '1_day_ago':
            	$startDate = $now->modify('-1 day')->format('Y-m-d');
            	$endDate = $startDate;
            	break;
        	case '2_days_ago':
            	$startDate = $now->modify('-2 days')->format('Y-m-d');
            	$endDate = $startDate;
            	break;
        	case '3_days_ago':
            	$startDate = $now->modify('-3 days')->format('Y-m-d');
            	$endDate = $startDate;
            	break;
        	case '4_days_ago':
            	$startDate = $now->modify('-4 days')->format('Y-m-d');
            	$endDate = $startDate;
            	break;
        	case '5_days_ago':
            	$startDate = $now->modify('-5 days')->format('Y-m-d');
            	$endDate = $startDate;
            	break;
        	case '6_days_ago':
            	$startDate = $now->modify('-6 days')->format('Y-m-d');
            	$endDate = $startDate;
            	break;
        	case '7_days_ago':
            	$startDate = $now->modify('-7 days')->format('Y-m-d');
            	$endDate = $startDate;
            	break;
        	case 'last_7_days':
            	$startDate = $now->modify('-7 days')->format('Y-m-d');
            	$endDate = $today;
            	break;
        	case 'last_30_days':
            	$startDate = $now->modify('-30 days')->format('Y-m-d');
            	$endDate = $today;
            	break;
        	case 'last_1_year':
            	$startDate = $now->modify('-1 year')->format('Y-m-d');
            	$endDate = $today;
            	break;
        	default:
            	$startDate = $today;
            	$endDate = $today;
            	break;
    	}

    	// Fetch all submissions for the selected time period
    	$query = $db->getQuery(true)
        	->select($db->quoteName(array('s.SubmissionId', 'v.FieldName', 'v.FieldValue')))
        	->from($db->quoteName('#__rsform_submissions', 's'))
        	->join('INNER', $db->quoteName('#__rsform_submission_values', 'v') . ' ON s.SubmissionId = v.SubmissionId')
        	->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
        	->where($db->quoteName('v.FieldName') . ' IN (' . $db->quote('Local_Time') . ', ' . $db->quote('Check-in') . ', ' . $db->quote('CheckOutTime') . ', ' . $db->quote('HoursWorked') . ', ' . $db->quote('Overtime') . ', ' . $db->quote('HasPPE') . ', ' . $db->quote('PayAmount') . ', ' . $db->quote('OvertimePayAmount') . ', ' . $db->quote('WorkerEfficiencyRating') . ', ' . $db->quote('SupervisorPerformanceRemarks') . ')')
        	->where($db->quoteName('v.FieldValue') . ' BETWEEN ' . $db->quote($startDate . ' 00:00:00') . ' AND ' . $db->quote($endDate . ' 23:59:59'));

    	$db->setQuery($query);
    	$submissions = $db->loadObjectList();

    	// Initialize metrics
    	$metrics = [
        	'total_workers' => 0,
        	'early_arrivals' => 0,
        	'late_arrivals' => 0,
        	'late_checkouts' => 0,
        	'total_hours_worked' => 0,
        	'total_overtime' => 0,
        	'with_ppe' => 0,
        	'without_ppe' => 0,
        	'total_payments' => 0,
        	'total_overtime_payments' => 0,
        	'efficiency_ratings' => [
            	'Unsatisfactory' => 0,
            	'Needs Improvement' => 0,
            	'Meets Expectations' => 0,
            	'Exceeds Expectations' => 0,
            	'Outstanding' => 0,
        	],
        	'performance_remarks' => [
            	'Poor' => 0,
            	'Fair' => 0,
            	'Good' => 0,
            	'Very Good' => 0,
            	'Excellent' => 0,
        	],
    	];

    	// Group submissions by SubmissionId
    	$groupedSubmissions = [];
    	foreach ($submissions as $submission) {
        	$submissionId = $submission->SubmissionId;
        	if (!isset($groupedSubmissions[$submissionId])) {
            	$groupedSubmissions[$submissionId] = [];
        	}
        	$groupedSubmissions[$submissionId][$submission->FieldName] = $submission->FieldValue;
    	}

    	// Process submissions
    	foreach ($groupedSubmissions as $submission) {
        	// Total number of workers
        	$metrics['total_workers']++;

        	// Early arrivals (Check-in before 8:30 AM)
        	if (isset($submission['Check-in'])) {
            	$checkInTime = strtotime($submission['Check-in']);
            	if ($checkInTime < strtotime('08:30:00')) {
                	$metrics['early_arrivals']++;
            	} else {
                	$metrics['late_arrivals']++;
            	}
        	}

        	// Late checkouts (CheckOutTime after 5:00 PM)
        	if (isset($submission['CheckOutTime'])) {
            	$checkOutTime = strtotime($submission['CheckOutTime']);
            	if ($checkOutTime > strtotime('17:00:00')) {
                	$metrics['late_checkouts']++;
            	}
        	}

        	// Total hours worked
        	if (isset($submission['HoursWorked'])) {
            	$metrics['total_hours_worked'] += (float) $submission['HoursWorked'];
        	}

        	// Total overtime worked
        	if (isset($submission['Overtime'])) {
            	$metrics['total_overtime'] += (float) $submission['Overtime'];
        	}

        	// Workers with and without PPE
        	if (isset($submission['HasPPE'])) {
            	if ($submission['HasPPE'] === 'Yes') {
                	$metrics['with_ppe']++;
            	} else {
                	$metrics['without_ppe']++;
            	}
        	}

        	// Total daily payments
        	if (isset($submission['PayAmount'])) {
            	$metrics['total_payments'] += (float) $submission['PayAmount'];
        	}

        	// Total daily overtime payments
        	if (isset($submission['OvertimePayAmount'])) {
            	$metrics['total_overtime_payments'] += (float) $submission['OvertimePayAmount'];
        	}

        	// Worker efficiency ratings
        	if (isset($submission['WorkerEfficiencyRating'])) {
            	$rating = $submission['WorkerEfficiencyRating'];
            	if (isset($metrics['efficiency_ratings'][$rating])) {
                	$metrics['efficiency_ratings'][$rating]++;
            	}
        	}

        	// Supervisor performance remarks
        	if (isset($submission['SupervisorPerformanceRemarks'])) {
            	$remark = $submission['SupervisorPerformanceRemarks'];
            	if (isset($metrics['performance_remarks'][$remark])) {
                	$metrics['performance_remarks'][$remark]++;
            	}
        	}
    	}

    	return $metrics;
	}
}